<?php

namespace Imagely\NGG\DynamicStylesheets;

use Imagely\NGG\Display\View;
use Imagely\NGG\Util\Sanitization;

class Controller {

	public function index_action( $return = false ) {
		header( 'Content-Type: text/css; charset=' . get_option( 'blog_charset' ), true );

		if ( \C_NextGEN_Bootstrap::get_pro_api_version() < 4.0 ) {
			$manager = Manager::get_instance( 'all' );
			$manager->register( 'nextgen_pro_film', 'photocrati-nextgen_pro_film#nextgen_pro_film_dyncss' );
			$manager->register( 'nextgen_pro_grid_album', 'photocrati-nextgen_pro_albums#nextgen_pro_grid_album_dyncss' );
			$manager->register( 'nextgen_pro_list_album', 'photocrati-nextgen_pro_albums#nextgen_pro_list_album_dyncss' );
			$manager->register( 'nextgen_pro_blog', 'photocrati-nextgen_pro_blog_gallery#nextgen_pro_blog_dyncss' );
			$manager->register( 'nextgen_pro_thumbnail_grid', 'photocrati-nextgen_pro_thumbnail_grid#nextgen_pro_thumbnail_grid_dyncss' );
		}

		// Nonce verification is not necessary: this is not form data, but generated by NextGEN as part of its displayed
		// gallery customization for style.
		//
        // phpcs:disable WordPress.Security.NonceVerification.Recommended
		$data = Sanitization::recursive_stripslashes( $_REQUEST['data'] );
		$name = Sanitization::recursive_stripslashes( $_REQUEST['name'] );
		// phpcs:enable WordPress.Security.NonceVerification.Recommended

		if ( isset( $data ) && isset( $name ) ) {
			$manager = Manager::get_instance( 'all' );

			if ( \C_NextGEN_Bootstrap::get_pro_api_version() < 4.0 ) {
				$view = new \C_MVC_View( $manager->get_css_template( $name ), $manager->decode( $data ) );
			} else {
				$view = new View( $manager->get_css_template( $name ), $manager->decode( $data ) );
			}

			return $view->render( $return );
		}
	}
}
